////////////////////////////////////////////////////////////////////////////////
//
// Przyklad wykorzystania makra ochrony pamieci PELOCK_MEMORY_GAP
//
// Wersja         : PELock v2.0
// Jezyk          : C/C++
// Autor          : Bartosz Wjcik (support@pelock.com)
// Strona domowa  : https://www.pelock.com
//
////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <math.h>
#include "gui.h"
#include "pelock.h"

// przykladowa procedura
void SaveConfig(void)
{
	unsigned int i = 0, j = 0;

	// makro spowoduje, ze po uruchomieniu aplikacji w pamieci aplikacji
	// zostanie umieszczony obszar niedostepny dla samej aplikacji (jedynie
	// w obszarze makra), stanowi to dodatkowe zabezpieczenie przed zrzucaniem
	// pamieci aplikacji (dumping), makro to nie ma zadnego wplywu na dzialanie
	// aplikacji i moze byc umieszczane w dowolnych punktach programu
	PELOCK_MEMORY_GAP

	j = 1;

	for (i = 0; i < 10; i++)
	{
		j += i;
	}

	j = 5;

	j = 3;

	if (j == 3)
	{
		i = 1;
	}
	else
	{
		i = 0;
	}
}

BOOL CALLBACK DlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
		// inicjalizacja glownego okna
		case WM_INITDIALOG:

			SetWindowText(hDlg, "PELock Test");

			return TRUE;

		case WM_COMMAND:

			switch (LOWORD (wParam))
			{
				case IDCANCEL:

					EndDialog(hDlg, 0);
					break;
			}
			break;
	}

	return FALSE;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	INITCOMMONCONTROLSEX iccControls = { sizeof(INITCOMMONCONTROLSEX), ICC_WIN95_CLASSES | ICC_DATE_CLASSES };

	// inicjalizuj kontrolki
	InitCommonControlsEx(&iccControls);

	// bez klucza, aplikacja nie wyswietli glownego okna
	DEMO_START

	DialogBox(hInstance, MAKEINTRESOURCE(DLG_MAIN), 0, DlgProc);

	SaveConfig();

	DEMO_END

	return 0;
}
